# Rule 0–1–12 (Required) There shall be no unused parameters (named or unnamed) in the set of parameters for a virtual function and all the functions that override it.

## Rationale
Unused function parameters are often due to design changes and can lead to mismatched parameter lists.

## Example
```c
class A 
{ 
public: 
 virtual void withunusedpara ( uint16_t * para1, 
 int16_t unusedpara ) = 0; 
 virtual void withoutunusedpara ( uint16_t * para1, 
 int16_t & para2 ) = 0; 
};
class B1: public A 
{ 
public: 
 virtual void withunusedpara ( uint16_t * para1, 
 int16_t unusedpara ) 
 { 
 *para1 = 1U; 
 }
 virtual void withoutunusedpara ( uint16_t * para1, 
 int16_t & para2 ) 
 { 
 *para1 = 1U; 
 } 
};
class B2: public A 
{ 
public: 
 virtual void withunusedpara ( uint16_t * para1, 
 int16_t unusedpara ) 
 { 
 *para1 = 1U; 
 }
 virtual void withoutunusedpara ( uint16_t * para1, 
 int16_t & para2 ) 
 { 
 para2 = 0; 
 } 
};
```

## See also
Rule 0–1–11

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
