# Rule 12–8–1 (Required) A copy constructor shall only initialize its base classes and the non-static members of the class of which it is a member.

## Amplification
[Implementation 12.8(15)]

## Rationale
If a compiler implementation detects that a call to a copy constructor is redundant, then it is permitted to omit that call, even if the copy constructor has a side effect other than to construct a copy of the object. This is called copy elision.
It is therefore important to ensure that a copy constructor does not modify the program state as the number of such modifications may be indeterminate.

## Example
```c
class A 
{ 
public: 
 A ( A const & rhs ) 
 : m_i ( rhs.m_i ) 
 { 
 ++m_static; // Non-compliant 
 }
private: 
 int32_t m_i; 
 static int32_t m_static; 
};
int32_t A::m_static = 0;
A f ( ) 
{ 
 return A ( ); 
}
void b ( ) 
{ 
 A a = f ( ); 
}
```
The value that m_static has after the call to b( ) is implementation-defined.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
