# Rule 15–0–3 (Required) Control shall not be transferred into a try or catch block using a goto or a switch statement.

## Rationale
A program is ill-formed if control is transferred into a try or catch block using a goto or switch statement; however, not all compilers issue a diagnostic message.

## Example
```c
void f ( int32_t i ) 
{ 
 if ( 10 == i ) 
 { 
 goto Label_10; // Non-compliant 
 }
 if ( 11 == i ) 
 { 
 goto Label_11; // Non-compliant 
 }
 switch ( i ) 
 { 
 case 1: 
 try 
 { 
 Label_10: 
 case 2: // Non-compliant – also violates switch rules 
 // Action 
 break; 
 }
 catch ( ... ) 
 { 
 Label_11: 
 case 3: // Non-compliant – also violates switch rules 
 // Action 
 break; 
 } 
 break;
 default: 
 { 
 // Default Action 
 break; 
 } 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
