# Rule 15–3–6 (Required) Where multiple handlers are provided in a single try-catch statement or function-try-block for a derived class and some or all of its bases, the handlers shall be ordered most-derived to base class.

## Rationale
When testing to see if the type of an exception matches the type of a handler, a derived class exception will match with a handler for its base class. If the base class handler is found before the handler for the derived class, the base class handler will be used. The derived class handler is unreachable code and can never be executed.

## Example
```c
// classes used for exception handling 
class B { }; 
class D: public B { };
try 
{ 
 // ... 
}
catch ( D &d ) // Compliant – Derived class caught before base class 
{ 
 // ... 
}
catch ( B &b ) // Compliant – Base class caught after derived class 
{ 
 // ... 
}
// Using the classes from above ... 
try 
{ 
 // ... 
}
catch ( B &b ) // Non-compliant – will catch derived classes as well 
{ 
 // ... 
}
catch ( D &d ) // Non-compliant – Derived class will be caught above 
{ 
 // Any code here will be unreachable, 
 // breaking Rule 0–1–1 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
