# Rule 17–0–1 (Required) Reserved identifiers, macros and functions in the standard library shall not be defined, redefined or undefined.

## Category
Required

## Rationale
[Undefined 16.8(3)]

It is generally bad practice to #undef a macro that is defined in the standard library. It is also bad
practice to #define a macro name that is a C++ reserved identifier, or C++ keyword or the name
of any macro, object or function in the standard library. For example, there are some specific
reserved words and function names that are known to give rise to undefined behaviour if they are
redefined or undefined, including defined, _ _LINE_ _, _ _FILE_ _, _ _DATE_ _, _ _TIME_ _,
_ _STDC_ _, errno and assert.
Refer to ISO/IEC 14882:2003 [1] for a list of the identifiers that are reserved. Generally, all
identifiers that begin with the underscore character are reserved.
Note that this rule applies regardless of which header files, if any, are actually included.

## Example
```cpp
#define __TIME__ 11111111 // Non-compliant
```

## See also
Rule 16–0–3

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
