# Rule 3–2–2 (Required) The One Definition Rule shall not be violated.

## Rationale
Violation of the One Definition Rule ([1] §3.2) leads to undefined behaviour. In general, this means that the program shall contain exactly one definition of every non-inline function or object.
Additionally:
* The definitions of a type shall consist of the same sequence of tokens, and;
* The definitions of a template shall consist of the same sequence of tokens, and;
* The definitions of an inline function shall consist of the same sequence of tokens.

Note that for the purposes of this rule, typedefs shall be treated as types.

## Example
```c
// File a.cpp 
struct S1 
{ 
 int32_t i; 
};
struct S2 
{ 
 int32_t i; 
};
// File b.cpp 
struct S1 
{ 
 int64_t i; 
}; // Non-compliant – token sequence different
struct S2 
{ 
 int32_t i; 
 int32_t j; 
}; // Non-compliant - token sequence different
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
