# Rule 5–0–20 (Required) Non-constant operands to a binary bitwise operator shall have the same underlying type.

## Rationale
Using operands of the same underlying type documents that it is the number of bits in the final (promoted and balanced) type that are used, and not the number of bits in the original types of the expression.

## Example
```c
uint8_t mask = ~(0x10); 
uint16_t value;
value ^= mask; // Non-compliant
```
The intent may have been to invert all bits except for bit 5, but the top 8 bits will not have been inverted.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
