# Rule 5–0–6 (Required) An implicit integral or floating-point conversion shall not reduce the size of the underlying type.

## Amplification
[Undefined 4.9(1)]

## Rationale
An implicit conversion that results in the size of a type being reduced may result in a loss of information.

## Example
```c
void f ( ) 
{ 
 int32_t s32; 
 int16_t s16;
 s16 = s32; // Non-compliant 
 s16 = static_cast< int16_t > ( s32 ); // Compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
