# Rule 5–2–12 (Required) An identifier with array type passed as a function argument shall not decay to a pointer.

## Rationale
When a variable with array type decays to a pointer, its bounds are lost.
If a design requires arrays of different lengths, then a class should be used to encapsulate the array objects and so ensure that the dimensionality is maintained.

## Example
```c
void f1( int32_t p[ 10 ] ); 
void f2( int32_t *p ); 
void f3( int32_t ( &p )[ 10 ] );
void b () 
{ 
 int32_t a[ 10 ]; 
 f1( a ); // Non-compliant - Dimension "10" lost due to array to 
 // pointer conversion. 
 f2( a ); // Non-compliant - Dimension "10" lost due to array to 
 // pointer conversion. 
 f3( a ); // Compliant - Dimension preserved. 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
