# Rule 5–2–2 (Required) A pointer to a virtual base class shall only be cast to a pointer to a derived class by means of dynamic_cast.

## Amplification
[Undefined 5.2.9(5, 8)]

## Rationale
Casting from a virtual base to a derived class, using any means other than dynamic_cast has undefined behaviour. The behaviour for dynamic_cast is defined.

## Example
```c
class B { ... }; 
class D: public virtual B { ... };
D d; 
B *pB = &d; 
D *pD = static_cast<D*>(pB); // Non-compliant - undefined behaviour 
D *pD2 = dynamic_cast<D*>(pB); // Compliant, but pD2 may be NULL 
D & D3 = dynamic_cast<D&>(*pB); // Compliant, but may throw an exception
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
