# Rule 5–3–2 (Required) The unary minus operator shall not be applied to an expression whose underlying type is unsigned.

## Rationale
Applying the unary minus operator to an expression of type unsigned int, unsigned long or unsigned long long generates a result of type unsigned int, unsigned long or unsigned long long respectively and is not a meaningful operation. Applying unary minus to an operand of smaller unsigned integer type may generate a meaningful signed result due to integral promotion, but this is not considered good practice.

## Example
On a machine with a 32‑bit int type:
```c
uint8_t a = -1U; // Non-compliant – a is assigned 255 
int32_t b = -a; // Non-compliant – b is assigned -255 
uint32_t c = 1U; 
int64_t d = -c; // Non-compliant – d is assigned MAX_UINT
```

## See also
See Section 6.5.0 for a description of underlying type.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
