# Rule 5–3–4 (Required) Evaluation of the operand to the sizeof operator shall not contain side effects.

## Rationale
A possible programming error in C++ is to apply the sizeof operator to an expression and expect the expression to be evaluated. However, the expression is not evaluated as sizeof only acts on the type of the expression. To avoid this error, sizeof shall not be used on expressions that would contain side effects if they were used elsewhere, as the side effects will not occur.

## Exception
An operand of the form sizeof ( i ) where i is volatile is permitted.

## Example
```c
 int32_t i; 
 int32_t j; 
volatile int32_t k;
j = sizeof( i = 1234 ); // Non-compliant - j is set to the sizeof the 
 // type of i which is an int32_t. 
 // i is not set to 1234. 
j = sizeof ( k ); // Compliant by exception.
```

## See also
ISO/IEC 14882:2003 [1] §3.2(2)

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
