# Rule 5–8–1 (Required) The right hand operand of a shift operator shall lie between zero and one less than the width in bits of the underlying type of the left hand operand.

## Amplification
[Undefined 5.8(1)]

## Rationale
It is undefined behaviour if the right hand operand is negative, or greater than or equal to the width of the left hand operand.
If, for example, the left hand operand of a left-shift or right-shift is a 16-bit integer, then it is important to ensure that this is shifted only by a number between 0 and 15 inclusive.
There are various ways of ensuring that this rule is followed. The simplest is for the right hand operand to be a constant (whose value can then be statically checked). Use of an unsigned integer type will ensure that the operand is non-negative, so then only the upper limit needs to be checked (dynamically at run time or by review). Otherwise both limits will need to be checked.

## Example
```c
u8a = (uint8_t) ( u8a << 7 ); // Compliant 
u8a = (uint8_t) ( u8a << 9 ); // Non-compliant 
u16a = (uint16_t)( (uint16_t) u8a << 9 ); // Compliant
```

## See also
See Section 6.5.0 for a description of underlying type.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
