# Rule 6–4–4 (Required) A switch-label shall only be used when the most closely-enclosing compound statement is the body of a switch statement.

## Rationale
A switch-label can be placed anywhere within the statements that form the body of a switch statement, potentially leading to unstructured code. To prevent this from happening, the scope of a case-label or default-label shall be the compound statement forming the body of a switch statement. All case-clauses and the default-clause shall be at the same scope.

## Example
```c
switch ( x ) 
{ 
case 1: // Compliant 
 if ( ... ) 
 { 
 case 2: // Non-compliant 
 DoIt ( ); 
 } 
 break; 
default: 
 break; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
