# Rule 8–4–3 (Required) All exit paths from a function with non-void return type shall have an explicit return statement with an expression.

## Amplification
[Undefined 6.6.3(2)]

## Rationale
This expression gives the value that the function returns. The absence of a return with an expression leads to undefined behaviour (and the compiler may not give an error).

## Exception
This rule does not apply if a function exit is due to exception handling (i.e. a throw statement).

## Example
```c
int32_t fn1 ( void ) 
{ 
} // Non-compliant
int32_t fn3 ( int32_t x ) 
{ 
 if ( x > 100 ) 
 { 
 throw 42; // Compliant by exception 
 } 
 return ( x ); // Compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
