# Rule 9–3–2 (Required) Member functions shall not return non-const handles to class-data.

## Rationale
By implementing class interfaces with member functions the implementation retains more control over how the object state can be modified and helps to allow a class to be maintained without affecting clients. Returning a handle to class-data allows for clients to modify the state of the object without using any interfaces.

## Example
```c
class C 
{ 
public: 
 int32_t & getA () // Non-compliant 
 { 
 return a; 
 } 
private: 
 int32_t a; 
};
void b ( C & c ) 
{ 
 int32_t & a_ref = c.getA (); 
 a_ref = 10; // External modification of private C::a 
}
```
c.getA() returns a reference to the member, which is then stored and modified by a_ref. The class, therefore, has no control over changes to its state.
Where a resource is used by the class, but is not class-data, non-const handles to this data may be returned.
```c
class C 
{ 
public: 
 C ( int32_t * shared ) : m_shared ( shared ) 
 { 
 }
 int32_t * getA () 
 { 
 return m_shared; // Compliant - m_shared is not class-data 
 } 
private: 
 int32_t * m_shared; 
};
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
