# Rule 10.0.1 A declaration should not declare more than one variable or member variable

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
An *init-declarator-list* or a *member-declarator-list* should consist of a single *init-declarator* or *member-declarator* respectively.

Structured bindings are permitted by this rule.

## Rationale
Where multiple declarators appear in the same *declaration*, the type of an identifier may not meet
developer expectations.

## Example
```cpp
int32_t i1; int32_t j1; // Compliant
int32_t i2, * j2; // Non-compliant
int32_t * i3,
 & j3 = i2; // Non-compliant

struct point
{
 int32_t x, y; // Non-compliant
};

std::map< char, char > map = f();

auto [ loc, inserted ] =
 map.insert( make_pair( 'A', 'a' ) ); // Compliant - structured binding
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
