# Rule 13.1.2 An accessible base class shall not be both virtual and non-virtual in the same hierarchy

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
Where a base class is inherited both virtually and non-virtually, it is unclear if the intent is for there to
be one or more instances of the base class subobject.

## Example
```cpp
class A {};

class B1: public virtual A {};
class B2: public virtual A {};
class B3: public A {};

class C: public B1, B2, B3 {}; // Non-compliant - C has two A subobjects
```

## See also
Rule 13.1.1

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
