# Rule 18.3.3 Handlers for a function-try-block of a constructor or destructor shall not refer to non-static members from their class or its bases

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
Referring to a non-static member of a class or a base class in the handler (i.e. the *catch* part) of a
*function-try-block* of a class constructor or destructor results in *undefined behaviour*.

For example, if a memory allocation exception is thrown during creation of the object, the object will
not exist when the handler attempts to access its members. Additionally, in the destructor, the object
may have been successfully destroyed before the exception is handled and it will not be available to
the handler.

## Example
```cpp
class C
{
public:
 int32_t x;

 C()
 try : x { mayThrow() }
 {
 }
 catch ( ... )
 {
 if ( 0 == x ) // Non-compliant - x may not exist at this point
 {
 }
 }

 ~C()
 try
 {
 // Action that may raise an exception
 }
 catch ( ... )
 {
 if ( 0 == x ) // Non-compliant - x may not exist at this point
 {
 }
 }
};
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
