# Rule 21.6.1 Dynamic memory should not be used

## Category
Advisory

## Analysis
Undecidable, Single Translation Unit

## Amplification
*Dynamic memory* refers to any object with dynamic storage duration that is managed using `operator
new` (excluding the non-allocating placement versions), `operator delete`, the functions `calloc`,
`malloc`, `realloc`, `aligned_alloc` and `free`, or any platform-specific memory allocation or
deallocation function.

Uses of *dynamic memory* may occur implicitly (e.g., when throwing exceptions or using C++ Standard
Library classes). Therefore, any instantiation of a C++ Standard Library *entity* having a template
argument that is a specialization of `std::allocator` is a violation of this rule, as is any call to a C++
Standard Library function that may use dynamic memory.

## Rationale
It is acknowledged that applications may need to use dynamic memory, leading to violations of this
rule. Any uses of *dynamic memory* need to be justified through supporting documentation that explains
how the issues that have been identified in Section 4.21.6 are managed within the project.

*Note:* a project may reclassify this rule (see MISRA Compliance [1]) if the risks related to the use
of dynamic memory are considered to be unacceptable.

## Example
```cpp
auto i = std::make_unique< int32_t >( 42 ); // Non-compliant
auto j = std::vector< int32_t > {}; // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
