# Rule 30.0.1 The C Library input/output functions shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule applies to the functions that are specified as being provided by `<cstdio>` and the wide-character equivalents specified as being provided by `<cwchar>`.

None of these identifiers shall be used and no macro with one of these names shall be expanded.

*Notes:*
1. Use of the same functions from `<stdio.h>` and `<wchar.h>` are also prohibited by this rule.
2. This rule does not prohibit the use of the facilities provided by `<fstream>`, even though they
may indirectly use functions from `<cstdio>` or `<cwchar>`.

## Rationale
Streams and file input/output have *undefined*, *unspecified* and *implementation-defined behaviours*
associated with them.

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
