# Rule 4.1.3 There shall be no occurrence of *undefined* or *critical unspecified* behaviour

## Category
Required

## Analysis
Undecidable, System

## Amplification
Many *undefined* and *unspecified behaviours* are covered by specific guidelines. This rule targets all other
*undefined* and *critical unspecified behaviour*.

An *unspecified behaviour* within the C++ Standard is considered to be *critical* when it impacts the
observable behaviour of the *abstract machine*.

For example:
*   [expr.static.cast]/9 states that the value resulting from the explicit conversion of a scoped
    enumeration type to an integral type is *unspecified* if the value cannot be represented — this is
    *critical* as it will have an impact on observable behaviour.
*   [global.functions]/1 states it is *unspecified* whether any non-member functions in the C++
    Standard Library are defined as `inline` — this is not *critical* as it will not have an impact on
    observable behaviour.

## Rationale
It is not possible to reason about the behaviour of any program that contains instances of *undefined
behaviour*. In addition, any program that contains instances of *unspecified behaviour* is not guaranteed
to behave predictably. These types of behaviour can be particularly difficult to detect during testing
as the program may appear to behave as expected for a given set of test data.

Many of the guidelines within this document have been designed to help ensure that certain *undefined*
and *unspecified behaviours* are avoided. However, other behaviours are not covered by specific guidelines
— for example, because there is no practical guidance that can be given, other than the obvious
statement that the behaviour should be avoided.

Note: an implementation is permitted to provide well-defined behaviour for a behaviour that is otherwise
stated within the C++ Standard as being *undefined* or *unspecified*. It will be necessary to raise a deviation
against this rule if any such well-defined behaviour is relied upon, including by means of the use of a
language extension.

## Example
The following examples are non-compliant:
```cpp
u32a >> u32b // Undefined behaviour if u32b > 31
static_cast< int8_t >( 128 ) // Unspecified - 128 is not representable as int8_t
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
