# Rule 5.13.1 Within character literals and non raw-string literals, `\` shall only be used to form a defined escape sequence or universal character name

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
The escape sequences defined within the C++ Standard are:
`\n, \t, \v, \b, \r, \f, \a, \\, \?, \', \", \<Octal Number>, \x<Hexadecimal Number>`

The universal character names are:
`\u hex-quad, \U hex-quad hex-quad`

## Rationale
The use of an undefined escape sequence results in *implementation-defined behaviour*.

## Example
```cpp
void fn()
{
  const char * a = "\k"; // Non-compliant
  const char * b = "\b\u00E9"; // Compliant
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
