# Rule 6.0.3 The only *declarations* in the global namespace should be `main`, namespace declarations and `extern "C"` declarations

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule also prohibits use of *using directives* and *inline namespaces* in the *global namespace*.

It does not apply to *namespace aliases*, `static_assert` or to names that are declared within the
C++ Standard.

## Rationale
Declaring names into appropriate *namespaces* reduces the names found during lookup, helping to
ensure that the names found meet developer expectations.

Adherence with this rule is particularly important within *header files*, as it reduces the chance that the
order of their inclusion will affect program behaviour.

Notes:
1.  *Using directives* and *inline namespaces* do not actually add names to the global namespace, but
    they do make them appear as if they are in it.
2.  Names declared within an *anonymous namespace* appear in the *global namespace*. However,
    their use is permitted as they do not have external linkage.

## Example
```cpp
void f1( int32_t ); // Non-compliant
int32_t x1; // Non-compliant

namespace // Compliant
{
  void f2( int32_t ); // Rule does not apply
  int32_t x2; // Rule does not apply
}

namespace MY_API // Compliant
{
  void b2( int32_t ); // Rule does not apply
  int32_t x2; // Rule does not apply
}

using namespace MY_API; // Non-compliant
using MY_API::b2; // Non-compliant
namespace MY = MY_API; // Compliant

int main() // Compliant
{
  extern void f3(); // Non-compliant
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
