# Rule 6.5.1 A function or object with external linkage should be *introduced* in a *header file*

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule applies to functions and objects with *namespace scope*. The *header file* containing the
*introduction* should be included by every *translation unit* in which it is defined or used.

This rule does not apply to the function `main`.

## Rationale
Placing the *introductions* of functions and objects with external linkage in a *header file* indicates that
they are intended to be accessed from multiple *translation units*. Requiring that this *header file* is
included by every *translation unit* that defines or uses the function or object ensures that the
declaration matches the definition.

If usage from multiple *translation units* is not required, then the visibility of the function or object
should be reduced by declaring it with internal linkage, for example, by declaring it within an unnamed
*namespace* of an *implementation file* (see Rule 6.5.2). This has the effect of increasing isolation and
encapsulation, which is considered to be good practice.

Compliance with this rule helps to prevent the issues identified in Rule 6.2.2.

## Example
```cpp
// header.hpp
extern int32_t a1; // Compliant
extern void f3(); // Compliant

// file1.cpp
#include "header.hpp"

int32_t a1 = 0; // Redeclaration - rule does not apply
int32_t a2 = 0; // Non-compliant - no declaration in header

namespace
{
  int32_t const a3 = 0; // Internal linkage - rule does not apply

  void f1() // Internal linkage - rule does not apply
  {
  }
}

void f2() // Non-compliant - no declaration in header
{
}

void f3() // Redeclaration - rule does not apply
{
}
```

## See also
Rule 6.2.2, Rule 6.5.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
