# Rule 6.5.2 Internal linkage should be specified appropriately

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
Internal linkage for an *entity* is specified appropriately when:
1.  It is declared within an anonymous namespace; and
2.  None of its *declarations* use the `extern` keyword; and
3.  It is not declared `static`.

This rule does not apply to variables declared `constexpr` or `const`.

## Rationale
Whilst the `static` keyword can be used to give an *entity* internal linkage, it also has other uses, which
may lead to confusion. An *entity* is unambiguously given internal linkage when it is declared in an
anonymous namespace, with the added advantage that this declarative form can be consistently
applied to all types of entity.

An *entity* in an anonymous namespace can be declared `extern`, but this does not have an impact on
its linkage.

## Example
```cpp
static void f1(); // Non-compliant

namespace
{
  void f2(); // Compliant
  int32_t notExtern1; // Compliant
  extern int32_t notExtern2; // Non-compliant
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
