# Rule 6.8.3 An assignment operator shall not assign the address of an object with automatic storage duration to an object with a greater lifetime

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule applies when the right-hand side of an assignment operator has the form `addressof( x )`,
`&x`, or is the name of an object having array type.

For the purposes of this rule, two objects with automatic storage duration that are declared in the
same scope are considered to have the same lifetime.

## Rationale
If the address of an automatic object is assigned to another automatic object of larger scope, or to an
object with static storage duration, then the object containing the address may exist beyond the time
when the original object ceases to exist (and its address becomes invalid).

Note: this rule and Rule 6.8.2 use decidable checks that allow trivial, specific instances of potentially
dangling references to be detected statically. Other (possibly non-decidable) cases are covered by
Rule 6.8.1.

## Example
```cpp
void f1()
{
  int8_t * p;

  {
    int8_t local;
    int8_t local_array[ 10 ];

    p = &local; // Non-compliant
    p = local_array; // Non-compliant
  }
}
```
The following example is compliant with this rule, but violates Rule 6.8.1.
```cpp
void f2()
{
  int8_t * p1;

  {
    int8_t * p2 = nullptr;
    int8_t local;

    p2 = &local; // Compliant - objects have the same lifetime
    p1 = p2; // Rule does not apply
  }

  *p1 = 0; // Undefined behaviour
}
```

## See also
Rule 6.8.1, Rule 6.8.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
