# Rule 8.18.2 The result of an assignment operator should not be *used*

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule applies to simple and compound assignments, built-in or overloaded, even if they occur in
an *infeasible path*. It does not apply to assignments within an *unevaluated operand*.

## Rationale
The use of assignment operators, simple or compound, in combination with other arithmetic operators
is not recommended because:
*   It can significantly impair the readability of the code;
*   It introduces additional *side effects* into a statement, making it more difficult to avoid the
    *undefined behaviour* covered by Rule 4.6.1.

## Example
```cpp
x = y; // Compliant
a[ x ] = a[ x = y ]; // Non-compliant - value of x = y is used

if ( bool_a = bool_b ) // Non-compliant - value of bool_a = bool_b is used
{ // (bool_a == bool_b was probably intended)
}

if ( uint8_t i = y ) // Rule does not apply - not an assignment operator
{
}

if ( ( 0u == 0u ) || ( bool_a = bool_b ) ) // Non-compliant - even though
{ // bool_a = bool_b is not evaluated
}

if ( ( x = f() ) != 0 ) // Non-compliant - value of x = f() is used
{
}

a[ b += c ] = a[ b ]; // Non-compliant - value of b += c is used

a = b = c = 0; // Non-compliant - values of c = 0, b = c = 0 are used
```

## See also
Rule 4.6.1

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
