Ensures component `standalone` property is set to `true` in the component decorator

- Type: suggestion
- 🔧 Supports autofix (`--fix`)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({})
~~~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({ standalone: false })
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
~~~~~~~~~~~~
standalone: false,
~~~~~~~~~~~~~~~~~~
template: '<div></div>'
~~~~~~~~~~~~~~~~~~~~~~~
})
~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
~~~~~~~~~~~~
template: '<div></div>'
~~~~~~~~~~~~~~~~~~~~~~~
})
~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
~~~~~~~~~~~~
selector: 'my-selector',
~~~~~~~~~~~~~~~~~~~~~~~
template: '<div></div>'
~~~~~~~~~~~~~~~~~~~~~~~
})
~~
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  standalone: true,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  standalone: true,
  selector: 'test-selector'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'test-selector',
  standalone: true,
  template: '<div></div>',
  styleUrls: ['./test.css']
})
class Test {}
```

</details>
