The ./ and ../ prefix is standard syntax for relative URLs; don't depend on Angular's current ability to do without that prefix. See more at https://angular.io/styleguide#style-05-04

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  styleUrls: ['./foo.css', 'bar.css', '../baz.scss', '../../test.css']
                           ~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  templateUrl: 'foobar.html'
               ~~~~~~~~~~~~~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  styleUrls: [
    './foo.css',
    '../bar.css',
    '../../baz.scss',
    '../../../baz.sass',
    './../test.css',
    '.././angular.sass'
  ]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  templateUrl: './foobar.html'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  templateUrl: '../foobar.html'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  templateUrl: '../../foobar.html'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  templateUrl: '../../../foobar.html'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  templateUrl: './../foobar.html'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  templateUrl: '.././foobar.html'
})
class Test {}
```

</details>
