The conditional complexity should not exceed a rational limit

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<div *ngIf="a === '3' || (b === '3' && c.d !== '1' && e.f !== '6' && q !== g)">
            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Content
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-container *ngIf="control && control.invalid && (control.touched || (showOnDirty && control.dirty))">
                     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Content
</ng-container>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-container *ngIf="control && control.invalid && (control.touched || (showOnDirty && control.dirty)) && control.errors | keys as errorKeys">
                     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  {{ errorKeys }}
</ng-container>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [class.px-4]="a <= b || (b > c && c >= d && d < e)">
                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Content
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [class.my-2]="a === 'x' ? v === c : b === 3 ? 0 : c > 3 && d === 9 ? 9 : 'xa'">
                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Content
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ test.xyz }} {{ ab > 2 && cd === 9 && control?.invalid && (control.touched || (showOnDirty && control.dirty)) ? 'some value' : 'another value' }} {{ control.touched }}
                  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-container
  *ngIf="(control | isDefined) && control.invalid && (control.touched || (showOnDirty && control.dirty))">
         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Content
</ng-container>
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<div *ngIf="a === '1' || b === '2' && c.d !== e">Content</div>
<div *ngIf="isValid; then thenTemplateRef; else elseTemplateRef">Content</div>
<ng-template #thenTemplateRef>thenTemplateRef</ng-template>
<ng-template #elseTemplateRef>elseTemplateRef</ng-template>
<div [class.mw-100]="test === 7"></div>
<div [attr.aria-label]="testing === 'ab' ? 'bc' : 'de'"></div>
<div [attr.custom-attr]="'test345' | appPipe"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div class="col" id="one-two-three-four-five-six-seven-eight-{{9}}"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngIf="a === '3' || (b === '3' && c.d !== '1' && e.f !== '6' && q !== g)">
  Content
</div>
```

</details>
