Enforces where React component static properties should be positioned.


This rule allows you to enforce where `childContextTypes`, `contextTypes`, `contextType`, `defaultProps`, `displayName`,
and `propTypes` are declared in an ES6 class.

## Rule Details

By default, this rule will check for and warn about declaring any of the above properties outside of the class body.

The three key options are `static public field`, `static getter`, and `property assignment`.

### When `static public field` is enabled (default)

Examples of **incorrect** code for this rule:

```js
class MyComponent extends React.Component {
  static get childContextTypes() { /*...*/ }
  static get contextTypes() { /*...*/ }
  static get contextType() { /*...*/ }
  static get displayName() { /*...*/ }
  static get defaultProps() { /*...*/ }
  static get propTypes() { /*...*/ }
}
```

```js
class MyComponent extends React.Component { /*...*/ }
MyComponent.childContextTypes = { /*...*/ };
MyComponent.contextTypes = { /*...*/ };
MyComponent.contextType = { /*...*/ };
MyComponent.displayName = "Hello";
MyComponent.defaultProps = { /*...*/ };
MyComponent.propTypes = { /*...*/ };
```

Examples of **correct** code for this rule:

```js
class MyComponent extends React.Component {
  static childContextTypes = { /*...*/ };
  static contextTypes = { /*...*/ };
  static contextType = { /*...*/ };
  static displayName = "Hello";
  static defaultProps = { /*...*/ };
  static propTypes = { /*...*/ };
}
```

### When `static getter` is enabled

Examples of **incorrect** code for this rule:

```js
class MyComponent extends React.Component {
  static childContextTypes = { /*...*/ };
  static contextTypes = { /*...*/ };
  static contextType = { /*...*/ };
  static displayName = "Hello";
  static defaultProps = { /*...*/ };
  static propTypes = { /*...*/ };
}
```

```js
class MyComponent extends React.Component { /*...*/ }
MyComponent.childContextTypes = { /*...*/ };
MyComponent.contextTypes = { /*...*/ };
MyComponent.contextType = { /*...*/ };
MyComponent.displayName = "Hello";
MyComponent.defaultProps = { /*...*/ };
MyComponent.propTypes = { /*...*/ };
```

Examples of **correct** code for this rule:

```js
class MyComponent extends React.Component {
  static get childContextTypes() { /*...*/ }
  static get contextTypes() { /*...*/ }
  static get contextType() { /*...*/ }
  static get displayName() { /*...*/ }
  static get defaultProps() { /*...*/ }
  static get propTypes() { /*...*/ }
}
```

### When `property assignment` is enabled

Examples of **incorrect** code for this rule:

```js
class MyComponent extends React.Component {
  static childContextTypes = { /*...*/ };
  static contextTypes = { /*...*/ };
  static contextType = { /*...*/ };
  static displayName = "Hello";
  static defaultProps = { /*...*/ };
  static propTypes = { /*...*/ };
}
```

```js
class MyComponent extends React.Component {
  static get childContextTypes() { /*...*/ }
  static get contextTypes() { /*...*/ }
  static get contextType() { /*...*/ }
  static get displayName() { /*...*/ }
  static get defaultProps() { /*...*/ }
  static get propTypes() { /*...*/ }
}
```

Examples of **correct** code for this rule:

```js
class MyComponent extends React.Component { /*...*/ }
MyComponent.childContextTypes = { /*...*/ };
MyComponent.contextTypes = { /*...*/ };
MyComponent.contextType = { /*...*/ };
MyComponent.displayName = "Hello";
MyComponent.defaultProps = { /*...*/ };
MyComponent.propTypes = { /*...*/ };
```

## When Not To Use It

If you have no placement preference for React's static class properties.
