Spacing around commas improves readability of a list of items. Although most of the style guidelines for languages prescribe adding a space after a comma and not before it, it is subjective to the preferences of a project.

```js
var foo = 1, bar = 2;
var foo = 1 ,bar = 2;
```

## Rule Details

This rule enforces consistent spacing before and after commas in variable declarations, array literals, object literals, function parameters, and sequences.

This rule does not apply in either of the following cases:

* between two commas
* between opening bracket `[` and comma, to avoid conflicts with the [`array-bracket-spacing`](https://eslint.org/docs/rules/array-bracket-spacing) rule
* between comma and closing bracket `]`, to avoid conflicts with the [`array-bracket-spacing`](https://eslint.org/docs/rules/array-bracket-spacing) rule
* between comma and closing brace `}`, to avoid conflicts with the [`object-curly-spacing`](https://eslint.org/docs/rules/object-curly-spacing) rule
* between comma and closing parentheses `)`, to avoid conflicts with the [`space-in-parens`](https://eslint.org/docs/rules/space-in-parens) rule

## When Not To Use It

If your project will not be following a consistent comma-spacing pattern, turn this rule off.

## References

- https://www.crockford.com/code.html
- https://dojotoolkit.org/reference-guide/1.9/developer/styleguide.html
