The Comma Style rule enforces styles for comma-separated lists. There are two comma styles primarily used in JavaScript:

* The standard style, in which commas are placed at the end of the current line
* Comma First style, in which commas are placed at the start of the next line

One of the justifications for using Comma First style is that it can help track missing and trailing commas. These are problematic because missing commas in variable declarations can lead to the leakage of global variables and trailing commas can lead to errors in older versions of IE.

## Rule Details

This rule enforce consistent comma style in array literals, object literals, and variable declarations.

This rule does not apply in either of the following cases:

* comma preceded and followed by linebreak (lone comma)
* single-line array literals, object literals, and variable declarations

## When Not To Use It

This rule can safely be turned off if your project does not care about enforcing a consistent comma style.

## References

- https://gist.github.com/isaacs/357981
