For a vast majority of use cases, the result of the `typeof` operator is one of the following string literals: `"undefined"`, `"object"`, `"boolean"`, `"number"`, `"string"`, `"function"`, `"symbol"`, and `"bigint"`. It is usually a typing mistake to compare the result of a `typeof` operator to other string literals.

## Rule Details

This rule enforces comparing `typeof` expressions to valid string literals.

## When Not To Use It

You may want to turn this rule off if you will be using the `typeof` operator on host objects.

## References

- https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/typeof
