All module level imports should be at the top of the file. This means that there should be no statements in between module level imports.

### Anti-pattern

In this example, the `sys` import is not at the top of the file because `local.setlocale` occurs before it.

```python
import locale

locale.setlocale(locale.LC_ALL, 'en_US.UTF-8')

import sys
```

### Best practice

Change the code so that the method call occurs after the imports.

```python
import locale
import sys

locale.setlocale(locale.LC_ALL, 'en_US.UTF-8')
```
