Loop variables should not redefine the name of modules that are imported.

### Anti-pattern

In this example the `path` loop variable redefines the `path` module that is imported from `os`. The name of the loop variable should be changed.

```python
from os import path

for path in ['file1.py', 'file2.py']:
    print(path)
```

### Best practice

```python
from os import path

for file_name in ['file1.py', 'file2.py']:
    print(file_name)
```
