Makes sure that a explicit non-latest tag is used.

# Details
Having no tag for containers defaults to using the `:latest` tag.
The latest container image will be pulled and that may or may not be the expected version.
Looking at Docker as a popular software to build containers, there the `:latest` tag is nothing more than a tag.
Naturally, it is expected to be always the most recent pushed version of the container but that is not the case.
The `:latest` tag has no additional functionality.
It is the default if no other tag is given, which makes it error-prone for human mistakes.
A developer who accidentally forgets to tag his pushed container version would immediately overwrite the `:latest` image which could lead to unexpected behavior or even failing containers being deployed to your production cluster if it pulls the `:latest` image version.
The solution is to use unique and descriptive tags for example using the Git hashes is a common good practice.

# Further Reading:
- Anita Buehrle. Top 5 Kubernetes Best Practices From Sandeep Dinesh (Google). Mar. 6, 2018. url: https://www.weave.works/blog/kubernetes-best-practices
- Vladislav Supalov. What’s Wrong With The Docker :latest Tag? url: https://vsupalov.com/docker-latest-tag/
- Brendan Burns et al. Kubernetes Best Practices. First Edition. Sebastopol: O’Reilly Media, Inc., 2019. isbn: 9781492056478.
- Rémy-Christophe Schermesser. 8 Algolia-Tested Best Practices for Kubernetes. June 13, 2019. url: https://blog.algolia.com/8-algolia-tested-best-practices-kubernetes/