### SCS0034 - Password RequiredLength Not Set 

The RequiredLength property must be set with a minimum value of 8.

#### Risk

Weak password can be guessed or brute-forced.

#### Vulnerable Code

ASP.NET Identity default is 6.

```cs
PasswordValidator pwdv = new PasswordValidator();

```

#### Solution

See the solution for [Password Complexity](#SCS0033)

#### References

[CWE-521: Weak Password Requirements](https://cwe.mitre.org/data/definitions/521.html)  
[MSDN: ASP.NET Identity PasswordValidator Class](https://msdn.microsoft.com/en-us/library/microsoft.aspnet.identity.passwordvalidator.aspx)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)