<h2>Why is this an issue?</h2>
<p>Duplicated string literals make the process of refactoring complex and error-prone, as any change would need to be propagated on all
occurrences.</p>
<h3>Exceptions</h3>
<p>The following are ignored:</p>
<ul>
  <li> literals with fewer than 5 characters </li>
  <li> literals matching one of the parameter names </li>
  <li> literals used in attributes </li>
</ul>
<h2>How to fix it</h2>
<p>Use constants to replace the duplicated string literals. Constants can be referenced from many places, but only need to be updated in a single
place.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
public class Foo
{
    private string name = "foobar"; // Noncompliant

    public string DefaultName { get; } = "foobar"; // Noncompliant

    public Foo(string value = "foobar") // Noncompliant
    {
        var something = value ?? "foobar"; // Noncompliant
    }
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
public class Foo
{
    private const string Foobar = "foobar";

    private string name = Foobar;

    public string DefaultName { get; } = Foobar;

    public Foo(string value = Foobar)
    {
        var something = value ?? Foobar;
    }
}
</pre>

