<h2>Why is this an issue?</h2>
<p>Specifying the default parameter values in a method call is redundant. Such values should be omitted in the interests of readability.</p>
<h3>Noncompliant code example</h3>
<pre>
public void M(int x, int y=5, int z = 7) { /* ... */ }

// ...
M(1, 5); // Noncompliant, y has the default value
M(1, z: 7); // Noncompliant, z has the default value
</pre>
<h3>Compliant solution</h3>
<pre>
public void M(int x, int y=5, int z = 7) { /* ... */ }

// ...
M(1);
M(1);
</pre>

