<h2>Why is this an issue?</h2>
<p>There’s no point in forcing the overhead of a method call for a method that always returns the same constant value. Even worse, the fact that a
method call must be made will likely mislead developers who call the method thinking that something more is done. Declare a constant instead.</p>
<p>This rule raises an issue if on methods that contain only one statement: the <code>return</code> of a constant value.</p>
<h3>Noncompliant code example</h3>
<pre>
int GetBestNumber()
{
  return 12;  // Noncompliant
}
</pre>
<h3>Compliant solution</h3>
<pre>
const int BestNumber = 12;
</pre>
<p>or</p>
<pre>
static readonly int BestNumber = 12;
</pre>

