<h2>Why is this an issue?</h2>
<p>The standard assertions library methods such as <code>AreEqual</code> and <code>AreSame</code> in <strong>MSTest</strong> and
<strong>NUnit</strong>, or <code>Equal</code> and <code>Same</code> in <strong>XUnit</strong>, expect the first argument to be the expected value and
the second argument to be the actual value.</p>
<h3>What is the potential impact?</h3>
<p>Having the expected value and the actual value in the wrong order will not alter the outcome of tests, (succeed/fail when it should) but the error
messages will contain misleading information.</p>
<p>This rule raises an issue when the actual argument to an assertions library method is a hard-coded value and the expected argument is not.</p>
<h2>How to fix it</h2>
<p>You should provide the assertion methods with a hard-coded value as the expected value, while the actual value of the assertion should derive from
the portion of code that you want to test.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
Assert.AreEqual(runner.ExitCode, 0, "Unexpected exit code"); // Noncompliant; Yields error message like: Expected:&lt;-1&gt;. Actual:&lt;0&gt;.
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
Assert.AreEqual(0, runner.ExitCode, "Unexpected exit code");
</pre>

