<h2>Why is this an issue?</h2>
<p>When an anonymous type’s properties are copied from properties or variables with the same names, it yields cleaner code to omit the new type’s
property name and the assignment operator.</p>
<h3>Noncompliant code example</h3>
<pre>
var X = 5;

var anon = new
{
  X = X, //Noncompliant, the new object would have the same property without the "X =" part.
  Y = "my string"
};
</pre>
<h3>Compliant solution</h3>
<pre>
var X = 5;

var anon = new
{
  X,
  Y = "my string"
};
</pre>

