<h2>Why is this an issue?</h2>
<p>The <code>IEquatable&lt;T&gt;</code> interface has only one method in it: <code>Equals(&lt;T&gt;)</code>. If you’ve already written
<code>Equals(T)</code>, there’s no reason not to explicitly implement <code>IEquatable&lt;T&gt;</code>. Doing so expands the utility of your class by
allowing it to be used where an <code>IEquatable</code> is called for.</p>
<p><strong>Note</strong>: Classes that implement <code>IEquatable&lt;T&gt;</code> should also be <code>sealed</code>.</p>
<h3>Noncompliant code example</h3>
<pre>
class MyClass  // Noncompliant
{
  public bool Equals(MyClass other)
  {
    //...
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
sealed class MyClass : IEquatable&lt;MyClass&gt;
{
  public override bool Equals(object other)
  {
    return Equals(other as MyClass);
  }

  public bool Equals(MyClass other)
  {
    //...
  }
}
</pre>

