<h2>Why is this an issue?</h2>
<p>This rule raises an issue when a disposable type contains fields of the following types and does not implement a finalizer:</p>
<ul>
  <li> <code>System.IntPtr</code> </li>
  <li> <code>System.UIntPtr</code> </li>
  <li> <code>System.Runtime.InteropService.HandleRef</code> </li>
</ul>
<h3>Noncompliant code example</h3>
<pre>
using System;
using System.Runtime.InteropServices;

namespace MyLibrary
{
  public class Foo : IDisposable // Noncompliant: Doesn't have a finalizer
  {
    private IntPtr myResource;
    private bool disposed = false;

    protected virtual void Dispose(bool disposing)
    {
      if (!disposed)
      {
        // Dispose of resources held by this instance.
        FreeResource(myResource);
        disposed = true;

        // Suppress finalization of this disposed instance.
        if (disposing)
        {
          GC.SuppressFinalize(this);
        }
      }
    }

    public void Dispose() {
      Dispose(true);
    }
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;
using System.Runtime.InteropServices;

namespace MyLibrary
{
  public class Foo : IDisposable
  {
    private IntPtr myResource;
    private bool disposed = false;

    protected virtual void Dispose(bool disposing)
    {
      if (!disposed)
      {
        // Dispose of resources held by this instance.
        FreeResource(myResource);
        disposed = true;

        // Suppress finalization of this disposed instance.
        if (disposing)
        {
          GC.SuppressFinalize(this);
        }
      }
    }

    ~Foo()
    {
      Dispose(false);
    }
  }
}
</pre>
<h2>Resources</h2>
<ul>
  <li> Related: {rule:csharpsquid:S3881} - "IDisposable" should be implemented correctly </li>
</ul>

