<h2>Why is this an issue?</h2>
<p>This rule raises an issue when an externally visible enumeration is marked with <code>FlagsAttribute</code> and one, or more, of its values is not
a power of 2 or a combination of the other defined values.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
    [Flags]
    public enum Color // Noncompliant, Orange is neither a power of two, nor a combination of any of the defined values
    {
        None    = 0,
        Red     = 1,
        Orange  = 3,
        Yellow  = 4
    }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

namespace MyLibrary
{
    public enum Color // Compliant - no FlagsAttribute
    {
        None = 0,
        Red = 1,
        Orange = 3,
        Yellow = 4
    }

    [Flags]
    public enum Days
    {
        None = 0,
        Monday = 1,
        Tuesday = 2,
        Wednesday = 4,
        Thursday = 8,
        Friday = 16,
        All = Monday| Tuesday | Wednesday | Thursday | Friday    // Compliant - combination of other values
    }
}
</pre>

