<h2>Why is this an issue?</h2>
<p>The <a
href="https://learn.microsoft.com/dotnet/api/system.diagnostics.codeanalysis.excludefromcodecoverageattribute">ExcludeFromCodeCoverageAttribute</a> is
used to exclude portions of code from <a href="https://learn.microsoft.com/dotnet/core/testing/unit-testing-code-coverage">code coverage
reporting</a>. It is a bad practice to retain code that is not covered by unit tests. In .Net 5, the <code>Justification</code> property was added to
the <code>ExcludeFromCodeCoverageAttribute</code> as an opportunity to document the rationale for the exclusion. This rule raises an issue when no
such justification is given.</p>
<h3>Noncompliant code example</h3>
<pre>
public struct Coordinates
{
    public int X { get; }
    public int Y { get; }

    [ExcludeFromCodeCoverage] // Noncompliant
    public override bool Equals(object obj) =&gt; obj is Coordinates coordinates &amp;&amp; X == coordinates.X &amp;&amp; Y == coordinates.Y;

    [ExcludeFromCodeCoverage] // Noncompliant
    public override int GetHashCode()
    {
        var hashCode = 1861411795;
        hashCode = hashCode * -1521134295 + X.GetHashCode();
        hashCode = hashCode * -1521134295 + Y.GetHashCode();
        return hashCode;
    }
}
</pre>
<h3>Compliant solution</h3>
<pre>
public struct Coordinates
{
    public int X { get; }
    public int Y { get; }

    [ExcludeFromCodeCoverage(Justification = "Code generated by Visual Studio refactoring")] // Compliant
    public override bool Equals(object obj) =&gt; obj is Coordinates coordinates &amp;&amp; X == coordinates.X &amp;&amp; Y == coordinates.Y;

    [ExcludeFromCodeCoverage(Justification = "Code generated by Visual Studio refactoring")] // Compliant
    public override int GetHashCode()
    {
        var hashCode = 1861411795;
        hashCode = hashCode * -1521134295 + X.GetHashCode();
        hashCode = hashCode * -1521134295 + Y.GetHashCode();
        return hashCode;
    }
}
</pre>
<h2>Resources</h2>
<ul>
  <li> <a href="https://learn.microsoft.com/dotnet/api/system.diagnostics.codeanalysis.excludefromcodecoverageattribute">API browser</a> -
  ExcludeFromCodeCoverageAttribute </li>
  <li> <a href="https://learn.microsoft.com/dotnet/core/testing/unit-testing-code-coverage">DevOps and testing</a> - Code coverage reporting </li>
</ul>

