# SA1105

<table>
<tr>
  <td>Title</td>
  <td>Query clauses spanning multiple lines should begin on own line</td>
</tr>
<tr>
  <td>TypeName</td>
  <td>SA110xQueryClauses</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1105</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

A clause within a C# query expression spans across multiple lines, and does not begin on its own line.

## Rule description

A violation of this rule occurs when a query clause spans across multiple lines, but does not begin on its own line. For example:
```c#
    var elementDescriptions =
        from element in elements select GenerateElementDescription
        (
            element
        );
```

The query clauses can correctly be written as:
```c#
    var elementDescriptions =
        from element in elements
		select GenerateElementDescription
        (
            element
        );
```
 
## How to fix violations

To fix a violation of this rule, move the clause down to start on the next line.

## How to suppress violations

```c#
#pragma warning disable SA1105 // Query clauses spanning multiple lines should begin on own line
    var elementDescriptions =
        from element in elements select GenerateElementDescription
        (
            element
        );
#pragma warning restore SA1105 // Query clauses spanning multiple lines should begin on own line
```
