﻿## SA1110

<table>
<tr>
  <td>TypeName</td>
  <td>SA1110OpeningParenthesisMustBeOnDeclarationLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1110</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The opening parenthesis or bracket in a call to a C# method or indexer, or the declaration of a method or indexer, is
not placed on the same line as the method or indexer name.

## Rule description

A violation of this rule occurs when the opening bracket of a method or indexer call or declaration is not placed on the
same line as the method or indexer. The following examples show correct placement of the opening bracket:

```csharp
public string JoinName(string first, string last)
{
    return JoinStrings(
        first, last);
}

public int this[int x]
{
    get { return this.items[x]; }
}
```

## How to fix violations

To fix a violation of this rule, ensure that the opening bracket is placed on the same line as the name of the method or
indexer.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1110:OpeningParenthesisMustBeOnDeclarationLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1110 // OpeningParenthesisMustBeOnDeclarationLine
#pragma warning restore SA1110 // OpeningParenthesisMustBeOnDeclarationLine
```
